%% A script for demonstrating the usage of the poly-fit transfer matrix of
% a saxophone mouthpiece, which is stored in the file tmpolyfit.m

% by Song Wang, McGill University, Jan. 2022.
% song.wang5@mail.mcgill.ca

load('tmpolyfit.mat');

% it was fit using the normalized frequency [0, 1], and 1 corresponds to the maximum fitting frequency
freq = 0:fittingFreqMax;
freq_norm = freq/fittingFreqMax;
T = zeros(4, length(freq_norm));
T(1, :) = polyval(T11, freq_norm);
T(2, :) = polyval(T12, freq_norm);
T(3, :) = polyval(T21, freq_norm);
T(4, :) = polyval(T22, freq_norm);

Z_closed = T(1, :) ./ T(3, :); % the closed mouthpiece impedance
subplot(2, 1, 1)
semilogy(freq, abs(Z_closed));
ylabel('|Z|')
subplot(2, 1, 2)
plot(freq, angle(Z_closed));
ylabel('arg(Z)')
xlabel('Frequency (Hz)')
