%% DIY laser doppler vibrometer mirror galvonometer scanner
%  Mark Rau
%  January, 2025
% 
%  This script can be used to manually set the laser point position. This
%  is useful for checking the size of the area to be scanned and for
%  measuring it with a ruler to calibrate the scan to physical units of
%  distance.
%
%  For the scanning LDV setup, we have three USB connections to the
%  computer: one for the NI card, currently connected through a USB-A to
%  USB-C adaptor to the USB-C port; one for the pendulum controller board,
%  currently connected to the left side USB-A port; one for the scanning
%  microcontroller, currently connected to right side USB-A port.
%
%  Mark says that the power for the scanning controller should be turned on
%  last.
%
%  In the code below, COM5 seems to be associated with the scanner
%  controller and COM4 with the pendulum, no matter whether I connect them
%  to the right-side USB-A or left-side ports. The command 'serialportlist'
%  can be used to print the currently available ports. At the moment, it
%  only shows COM4 and COM5 as options, so I don't think the USB-C port is
%  an option. If you are connected to a valid but incorrect port, there are
%  no error messages to warn you that you aren't connected to the correct
%  one.

close all
clear all
clc

% Open serial connection. Use 'serialportlist' to find available ports.
% s = serial('COM3','BaudRate',9600);
% serialportlist
s = serial('COM5','BaudRate',115200);

fopen(s)

%% Manually find a scanning point

horizontalScanPoints = 20; % number of horizontal scanning points
verticalScanPoints = 20;   % number of vertical scanning points

n = 19; % horizontal scanning point integer (0 is left-most, horizontalScanPoints-1 is right-most) 
m = 19; % vertical scanning point integer (0 is bottom, verticalScanPoints-1 is top) 

x = n/(horizontalScanPoints-1); % determine normalized x increment
y = m/(verticalScanPoints-1);   % determine normalized y increment

x_pos = round(x*4095);
y_pos = round(-4095*y + 4095);

fullMessage = strcat("h",num2str(x_pos),"v",num2str(y_pos));
fprintf(s,fullMessage); % horizonatal LDV position with 0-4095

%% Close the serial port
fclose(s);
allSerialPorts = instrfind;
for i =1:length(allSerialPorts)
    fclose(allSerialPorts(i)); % To close
end
